#ifndef CALCULATING_H
#define CALCULATING_H

#include <qstring.h>
#include <qthread.h>
#include <cstdio>
#include "ui_calculating.h"
#include "extensions.h"
#include "cliques.h"
#include "graph.h"


extern volatile bool stopped;

#define CHECK_STOPPING          \
if (stopped)                    \
    throw("Computing stopped");

enum result_type { c_string, qt_string, c_double, no_result};

struct calculating
{
    QString result;
    result_type type;
};

class extensions_calculating : public QThread, public calculating
{
    Q_OBJECT

    CalculatingWindow *w;
    QString input_file_name;
    QString good_vertex_file_name;
    QString egraph_file_name;
    QString good_sets_file_name;
    QString max_exts_file_name;

public:

    extensions_calculating(CalculatingWindow&, const char*, const char*, const char*, const char*, const char*);
    void run();

public slots:

    void done();
};

class cliques_calculating : public QThread, public calculating
{
    Q_OBJECT

    CalculatingWindow *w;
    QString egraph_file_name;
    QString cliques_file_name;

public:

    cliques_calculating(CalculatingWindow&, const char*, const char*);
    void run();

public slots:

    void done();
};

class isomorphism_calculating : public QThread, public calculating
{
    Q_OBJECT

    CalculatingWindow *w;
    QString graphs_file_name;
    QString classes_file_name;

public:

    isomorphism_calculating(CalculatingWindow&, const char*, const char*);
    void run();

public slots:

    void done();
};

class CalculatingWindow : public QDialog, public Ui_CalculatingWindow
{
    Q_OBJECT

public:

    QString succesful_message, stopped_message;
    calculating *calc;

    CalculatingWindow(QString, QWidget* = 0);
    void print(QString);
    void undo();
    void closeEvent(QCloseEvent*);

public slots:

    void done();
    void stop_computing();
};

class extensions_window : public CalculatingWindow
{
public:

    QString result;
    result_type type;

    extensions_window(const char*, const char*, const char*, const char*, const char*);
};

class cliques_window : public CalculatingWindow
{
public:

    QString result;
    result_type type;

    cliques_window(const char*, const char*);
};

class isomorphism_window : public CalculatingWindow
{
public:

    QString result;
    result_type type;

    isomorphism_window(const char*, const char*);
};

#endif
