#include <fstream>
#include "graph_algorithm.h"
#include "jacobi.h"


ostream& operator <<(ostream &output, const conditions &cond)
{
    unsigned int i,j;

    for (i=0; i<cond.possible.size(); i++)
    {
        output << "The vertex " << i+1
             << " can be mapped at most in the next vertices:\n\n";

        for (j=0; j<cond.possible[i].size(); j++)
            if (cond.possible[i][j])
                output << "\t" << j+1;

        output << "\n\nThere are totally " << cond.possibilities[i] << " vertices!.\n\n";
    }

    return output;
}

isomorphism::isomorphism(graph g_1, graph g_2)
{
	g1 = g_1;
	g2 = g_2;
}

bool isomorphism::exists_by_condition(conditions &cond)
{
	int i,num,min,best;

	min = row+1;

	for (i=0; i<row; i++)
		if (f[i]==-1 && (num=cond.possibilities[i])<min)
		{
			best = i;
			min = num;
		}

	if (min==row+1)
		return true;

	if (min==0)
		return false;

	for (i=0; i<row; i++)
	{
		if (cond.possible[best][i])
		{
			conditions new_condition = cond;
			int j,k,s;

			f[best] = i;
			new_condition.possibilities[best] = 1;
			s = g1.neighbor[best].size();

			for (j=0; j<s; j++)
				for (k=0; k<row; k++)
				{
					int neig = g1.neighbor[best][j];

					if (new_condition.possible[neig][k])
						if (!g2.connected[i][k])
						{
							new_condition.possible[neig][k] = false;
							new_condition.possibilities[neig]--;
						}
				}

			for (j=0; j<row; j++)
				if (new_condition.possible[j][i])
					if (j!=best)
					{
						new_condition.possible[j][i] = false;
						new_condition.possibilities[j]--;
					}

			if (exists_by_condition(new_condition))
				return true;

			f[best] = -1;
		}
	}

	return false;
}

bool isomorphism::exists()
{
	conditions cond;
	int i,j;

	if (g1.neighbor.size()!=g2.neighbor.size())
		return false;

	row = g1.neighbor.size();

	{
	    vector<int> degree1, degree2;

	    for (i=0; i<row; i++)
	    {
			degree1.push_back(g1.neighbor[i].size());
			degree2.push_back(g2.neighbor[i].size());
	    }

	    sort(degree1.begin(), degree1.end());
	    sort(degree2.begin(), degree2.end());

	    if (degree1!=degree2)
			return false;
	}

	for (i=0; i<row; i++)
	{
		cond.possibilities.push_back(0);
		cond.possible.push_back(vector<bool>());
		f.push_back(-1);
	}

	for (i=0; i<row; i++)
		for (j=0; j<row; j++)
			if (g1.neighbor[i].size()==g2.neighbor[j].size())
			{
				cond.possibilities[i]++;
				cond.possible[i].push_back(true);
			}
			else
				cond.possible[i].push_back(false);

	return (exists_by_condition(cond));
}

istream& operator >>(istream &input, graph &g)
{
	char c;
	unsigned int i,j;

	input >> g.identifier;

	if (!input)
        throw("Warning: The graph identifier expected!");

	do
	{
		input.get(c);

		if (input.eof())
		    throw("Warning: Unexpected end of file!");
	}
	while (c!='0');

	g.connected.push_back(vector<bool>());
	g.neighbor.push_back(vector<int>());
	g.connected[0].push_back(false);

	do
	{
		input.get(c);

		if (input.eof())
			break;

		if (c=='0' || c=='1')
		{
			if (c=='1')
			{
			    if (g.connected[0].size()==0)
                    throw("Warning: Nonzero diagonal entries!");

				g.neighbor[0].push_back(g.connected[0].size());
			}

			g.connected[0].push_back(c=='1');
		}
		else
            if (c!=' ' && c!='\t' && c!='\n')
                throw("Warning: Unexpected token!");
	}
	while (c!='\n');

	for (i=1; i<g.connected[0].size(); i++)
	{
		g.connected.push_back(vector<bool>());
		g.neighbor.push_back(vector<int>());

		for (j=0; j<g.connected[0].size(); j++)
		{
			input >> c;

			if (input.eof())
				throw("Warning: Unexpected end of file!");

			if (c=='1')
				g.neighbor[i].push_back(g.connected[i].size());

			g.connected[i].push_back(c=='1');

			if (i>j)
                if (g.connected[i][j]!=g.connected[j][i])
                    throw ("Warning: Illegal entries!");
		}
	}

	return input;
}

ostream& operator <<(ostream &output, const graph &g)
{
	unsigned int i,j;


	output << g.identifier << "\n\n";

	for (i=0; i<g.connected.size(); i++)
	{
		for (j=0; j<g.connected[i].size(); j++)
			output << g.connected[i][j] << " ";

		output << "\n";
	}

	return output;
}

ostream& operator <<(ostream &output, const isomorphism &iz)
{
    unsigned int i;

    for (i=0; i<iz.f.size(); i++)
        output << "\t" << iz.f[i]+1;

    return output;
}

void calculate_classes(istream &input, ostream &output, bool show_header)
{
    vector<graph> l;
    unsigned int i,j, graphs = 0, classes = 0;
	bool end = false;

    do
    {
		try
		{
			graph g;

			input >> g;
			l.push_back(g);
		}
		catch(const char *s)
		{
		    if(input.eof())
                end = true;
            else
            {
                cout << endl;

                throw(s);
            }
		}
    }
	while (!end);

	graphs = l.size();
	vector<int> first_isomorphic;
	vector<int> representer;
    vector<vector<int> > cls;

	for (i=0; i<graphs; i++)
	{
	    vector<int>::iterator it;

		first_isomorphic.push_back(i);
		cout << "Graph " << l[i].identifier << " ... ";

		for (j=0; j<classes; j++)
        {
            isomorphism isomorph(l[i],l[representer[j]]);

            if (isomorph.exists())
            {
                first_isomorphic[i] = j;
                cls[j].push_back(i);

                break;
            }
        }

        if (first_isomorphic[i]==i)
        {
            representer.push_back(i);
            classes++;
            cls.push_back(vector<int>());
            cls[classes-1].push_back(i);
        }

        cout << "done\n";
	}

	if (show_header)
	{
        cout << "\n\nEquivalence classes are :\n\n";
        output << "Equivalence classes are :\n\n";

        for (i=0; i<classes; i++)
        {
            int num = cls[i].size();

            cout << "{" << l[cls[i][0]].identifier;
            output << "{" << l[cls[i][0]].identifier;

            for (j=1; j<num; j++)
            {
                cout << "," << l[cls[i][j]].identifier;
                output << "," << l[cls[i][j]].identifier;
            }

            cout << "}\n";
            output << "}\n";
        }

        cout << "\n\nGraphs : " << graphs << "\nClasses : " << classes << "\n";
        output << "\n\nThe represents are : ";
	}

	int k;

	for (k=0; k<classes; k++)
	{
	    if (!show_header)
            l[cls[k][0]].identifier = k+1;

        output << "\n\n" << l[cls[k][0]] << "\n\n[" << flush;
        long size = l[cls[k][0]].connected.size();
        symmetric_matrix m(size);

        for (i=1; i<=size; i++)
            for (j=i+1; j<=size; j++)
                m(i,j) = (l[cls[k][0]].connected[i-1][j-1] ? 1 : 0);

        cout << "Spectrum computing..." << endl;
        vector<real> v = m.spectrum();
        cout << "Spectrum computed." << endl;

        for (i=0; i<size; i++)
        {
            if (i>0)
                output << ",";

            output << v[i] << flush;
        }

        output << "]\n\n";
	}
}
