#include <vector>
#include <cmath>
#include <cstdio>
#include "extensions.h"
#include "jacobi.h"
#include "cliques.h"
#include "graph.h"
#include "all_max.h"

using namespace std;


symmetric_matrix input_matrix(istream&);
void find_good_vertex(symmetric_matrix&, real, vector< vector<int> >&);
void wait_for(char, istream&, const char*);

void maximal_extensions(istream &input, ostream &output)
{
    try
    {
    char c[1];
    input.getline(c,0);
    sub_dir = "extensions";
    output << "Calculating maximal extensions\n";
    output << "Enter the input file name.\n";
    string_converter inputfile_name = get_filename_open(string("input.txt"), input, output);
    ifstream inputfile(inputfile_name.c_string());
    output << "Enter the maximal extensions output file name.\n";
    string_converter max_exts_file_name = get_filename_create(string("maxexts.txt"), input, output);
    output << "Enter the good vertices output file name.\n";
    string_converter good_vertex_file_name = get_filename_create(string("goodvert.txt"), input, output);
    output << "Enter the e-graph output file name.\n";
    string_converter egraph_file_name = get_filename_create(string("egraph.txt"), input, output);
    output << "Enter the good sets output file name.\n";
    string_converter good_sets_file_name = get_filename_create(string("goodsets.txt"), input, output);
    ofstream outputfile(good_sets_file_name.c_string());

//  processingthrow("izlazna")

    real lambda;
    unsigned long int i, j, k;
    int l, counter;
    vector< vector<int> > good_vertex;

    symmetric_matrix c_matrix = input_matrix(inputfile);
    inputfile >> lambda;

    if (!inputfile)
        throw("Warning: Real number expected.");

    if (fabs(lambda+1)<EPS || fabs(lambda)<EPS)
        throw("Warning: The given eigenvalue must be distinct from 0 and -1.");

    output << "The star complement spectrum is" << endl;

    vector<real> spectrum = c_matrix.spectrum();

    for (i=0; i<spectrum.size(); i++)
        cout << spectrum[i] << endl;

    for (i=0; i<spectrum.size(); i++)
        if (fabs(lambda-(spectrum[i]))<EPS)
            throw ("Warning: The graph spectrum contains given eigenvalue!");

    find_good_vertex(c_matrix, lambda, good_vertex);

    {
    ofstream good_vertex_file(good_vertex_file_name.c_string());

    for (i=0; i<good_vertex.size(); i++)
        for (j=0; j<good_vertex[i].size(); j++)
        {
            good_vertex_file << good_vertex[i][j];

            if (j+1<good_vertex[i].size())
                good_vertex_file << " ";
            else
                good_vertex_file << "\n";
        }
    }

    symmetric_matrix ext_matrix(c_matrix.order()+2);
    symmetric_matrix e_matrix(good_vertex.size());
    symmetric_matrix n_matrix(good_vertex.size());

    for (i=1; i<=c_matrix.order(); i++)
        for (j=1; j<i; j++)
            ext_matrix(i,j) = c_matrix(i,j);

    for (i=1; i<good_vertex.size(); i++)
        for (j=0; j<i; j++)
        {
            for (k=1; k<=c_matrix.order(); k++)
            {
                ext_matrix(c_matrix.order()+1,k) = good_vertex[i][k-1];
                ext_matrix(c_matrix.order()+2,k) = good_vertex[j][k-1];
            }

            for (k=0; k<=1; k++)
            {
                ext_matrix(c_matrix.order()+1, c_matrix.order()+2) = k;
                ext_matrix(c_matrix.order()+2, c_matrix.order()+1) = k;
                spectrum = ext_matrix.spectrum();
                counter = 0;

                for (l=0; l<spectrum.size(); l++)
                    if (fabs(spectrum[l]-lambda)<EPS)
                        counter++;

                if (counter>1)
                {
                    e_matrix(i+1,j+1) = 1;
                    n_matrix(i+1,j+1) = k;

                    break;
                }
            }
        }

    {
        ofstream egraph_file(egraph_file_name.c_string());
        egraph_file << e_matrix;
    }   // brackets closes output file

    ifstream egraph_file(egraph_file_name.c_string());
    ofstream cliques_file("workspace/extensions/cliques.txt");

    calculate_cliques(egraph_file, cliques_file, false);
    all_max(c_matrix, n_matrix, good_vertex);

    {
        ifstream temp("maxexts.tmp");
        ofstream maxexts_file(max_exts_file_name.c_string());

        cout << "Maximal graphs computing..." << endl;
        maxexts_file << "The maximal graphs are:";
        calculate_classes(temp, maxexts_file, false);
    }   // brackets closes input and output files

    remove("maxexts.tmp");

    ifstream maxexts_file(max_exts_file_name.c_string());
    ofstream good_sets_file(good_sets_file_name.c_string());

    good_sets_file << "The good sets are:\n\n";

    while (true)
    {
        char c;

        wait_for('\n', maxexts_file, max_exts_file_name.c_string());
        maxexts_file >> i;

        if (maxexts_file.eof())
            break;

        good_sets_file << i << "\n\n";
        wait_for('0', maxexts_file, max_exts_file_name.c_string());

        unsigned long int order = 1;

        do
        {
            c = maxexts_file.get();

            if (maxexts_file.eof())
            {
                string error_message = "Warning: Unexpected end of file \'";

                error_message += max_exts_file_name.c_string();
                error_message += "\'";

                string_converter message(error_message);

                throw (message.c_string());
            }

            if (c=='0' || c=='1')
                order++;
        }
        while (c!='\n');

        for (i=0; i<c_matrix.order()-1; i++)
            wait_for('\n', maxexts_file, max_exts_file_name.c_string());

        for (i=0; i<order-c_matrix.order(); i++)
        {
            for (j=0; j<c_matrix.order(); j++)
            {
                maxexts_file >> k;
                good_sets_file << k;

                if (j<c_matrix.order()-1)
                    good_sets_file << " ";
            }

            good_sets_file << "\n";
            wait_for('\n', maxexts_file, max_exts_file_name.c_string());
        }

        good_sets_file << "\n";
        wait_for(']', maxexts_file, max_exts_file_name.c_string());
    }
    
    cout << "Maximal extensions computed!";

    throw((const char*) 0);
    }
    catch (const char *message)
    {
        remove("workspace/extensions/cliques.txt");

        if (message!=0)
            cout << message << endl;
    }
}

void wait_for(char c, istream &istr, const char *filename)
{
    char ch;

    do
    {
        ch = istr.get();

        if (istr.eof())
        {
            string error_message = "Warning: Unexpected end of file \'";

            error_message += filename;
            error_message += "\'";

            string_converter message(error_message);

            throw (message.c_string());
        }
    }
    while (ch!=c);
}
symmetric_matrix input_matrix(istream &istr)
{
    vector<int> v;
    char ch;

    do
    {
        ch = istr.get();

        if (istr.eof())
            break;

        if (ch=='0' || ch=='1')
        {
            v.push_back(ch-'0');

            continue;
        }

        if (ch=='\n')
            if (v.size()>0)
                break;
            else
                continue;

        if (ch!='\t' && ch!=' ' && ch!='\n')
        {
            while (ch!='\n')
            {
                ch = istr.get();

                if (istr.eof())
                    break;
            }
        }
    }
    while (!istr.eof());

    if (v.size()==0)
        throw("Warning: There is no input matrix!");

    if (v[0]==1)
        throw ("Warning: Illegal entries!");

    unsigned long int i, j;
    symmetric_matrix m(v.size());

    for (i=0; i<v.size(); i++)
        m(1,i+1) = v[i];

    for (i=2; i<=v.size(); i++)
        for (j=1; j<=v.size(); j++)
        {
            istr >> m(i,j);

            if (istr.eof())
                throw("Warning: Illegal entries!");

            if (i<j)
            {
                if (m(i,j)!=m(j,i))
                    throw ("Warning: Illegal entries!");
            }
            else
            if (i==j)
            {
                if (m(i,i)!=0)
                    throw ("Warning: Illegal entries!");
            }
        }

    return m;
}

void find_good_vertex(symmetric_matrix &c_matrix, real lambda,
vector< vector<int> > &good_vertex)
{
    vector<int> row;
    unsigned long int i, j;

    for (i=0; i<c_matrix.order(); i++)
        row.push_back(0);

    while (true)
    {
        for (i=0; i<row.size(); i++)
            if (row[i]==0)
                break;

        if (i>=row.size())
            return;

        row[i]=1;

        for (j=0; j<i; j++)
            row[j] = 0;

        symmetric_matrix ext_matrix(c_matrix.order()+1);

        for (i=1; i<=c_matrix.order(); i++)
            for (j=1; j<=i; j++)
                ext_matrix(i,j) = c_matrix(i,j);

        for (j=1; j<i; j++)
            ext_matrix(i,j) = row[j-1];

        ext_matrix(i,i) = 0;

        vector<real> spectrum = ext_matrix.spectrum();

        for (i=0; i<spectrum.size(); i++)
            if (fabs(lambda-spectrum[i])<EPS)
            {
                good_vertex.push_back(row);

                break;
            }
    }
}
